<?php

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (vudoanthang83@gmail.com)
 * @copyright	PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
$abspath = preg_replace('/\\\/', '/', dirname(dirname(__FILE__)));
if (!file_exists($abspath . '/configs/config.php')) {
    define('PF_VERSION','1.0');
    require $abspath . '/includes/functions.php';
    redirect_to_install($abspath);
}
require $abspath . '/configs/config.php';
session_name('PageFlex' .sha1(__SECURITY_SALT__ . __SECURITY_CIPHER_SEED__));
@session_start();
require ABSPATH . '/includes/helper/url-helper.php';
require ABSPATH . '/includes/error-handler-class.php';
require ABSPATH . '/includes/pf-class.php';
require ABSPATH . '/admin/plugins/user/class/authentication/auth.php';
require ABSPATH . '/admin/includes/option.php';
require ABSPATH . '/admin/plugins/user/class/pf-user.php';
require ABSPATH . '/includes/functions.php';
require ABSPATH . '/includes/common/libs/image/simple_image.php';


/**
 * Configuration
 */
$setting = Pf::setting();
define('DEFAULT_LOCALE', $setting->get_element_value('general', 'site_language'));
define('NUM_PER_PAGE', $setting->get_element_value('general', 'items_per_page'));
date_default_timezone_set(get_configuration('time_zone'));
if ($setting->get_element_value('general', 'enable_log') == 1) {
    new Pf_Error_Handler();
}
require ABSPATH . '/includes/paginator-class.php';
require ABSPATH . '/includes/helper/form-helper.php';
require ABSPATH . '/includes/File_Gettext/File/Gettext.php';
require ABSPATH . '/includes/helper/l10n-helper.php';
require ABSPATH . '/includes/widget-class.php';
require ABSPATH . '/includes/plugin-class.php';

require ABSPATH . '/admin/includes/functions.php';

if (is_null(Pf::auth()->get_session("user-id"))&&Pf::auth()->check_cookie("id")){
    set_session(Pf::auth()->get_cookie("id"));
}
if (!is_login()) {
    header("Location: " . site_url() . RELATIVE_PATH . '/admin/user.php?page=login&ref=' . urlencode($_SERVER['REQUEST_URI']));
    exit;
} elseif (is_User()) {
    header("Location: " . site_url() . RELATIVE_PATH . '/user/profile:view/');
}
global $_admin_css;

admin_css('admin/themes/default/assets/bootstrap/css/bootstrap.min.css');
admin_css('admin/themes/default/assets/font-awesome/css/font-awesome.min.css');
admin_css('admin/themes/default/assets/admin-lte/css/ionicons.min.css');
admin_css('admin/themes/default/assets/admin-lte/css/AdminLTE.css');
admin_css('admin/themes/default/assets/css/admin.css');
admin_css('admin/themes/default/assets/bootstrap-table/css/bootstrap-table.css');

global $_admin_js;

admin_js('admin/themes/default/assets/js/jquery-1.11.0.min.js');
admin_js('admin/themes/default/assets/bootstrap/js/bootstrap.min.js');
admin_js('admin/themes/default/assets/admin-lte/js/jquery-ui-1.10.3.min.js');
admin_js('admin/themes/default/assets/admin-lte/js/AdminLTE/app.js');
admin_js('admin/themes/default/assets/admin-lte/js/plugins/iCheck/icheck.min.js');
admin_js('admin/themes/default/assets/bootstrap-table/js/bootstrap-table.js');

global $_admin_menu;
global $_admin_toolbar_button;

$_admin_menu = array();
$_admin_toolbar_button = array();

global $_admin_plugin_content;
$_admin_plugin_content = '';

global $locale;


$locale = (!empty($_GET ['lang'])) ? $_GET ['lang'] : DEFAULT_LOCALE;
$_SESSION['lang'] = $locale;

load_admin_plugins(ADMIN_PLUGIN_PATH);
load_active_plugins();
load_theme_language('admin_theme','admin');
load_includes_language();
$theme = get_option('active_theme');
load_theme_language($theme.'-theme','',$theme);

$charset = get_configuration('charset_html');

global $admin_page;
$admin_page = (isset($_GET ['admin-page'])) ? $_GET ['admin-page'] : 'dashboard';
if($admin_page=='dashboard'){
    $_GET['admin-page'] = $admin_page;
}
global $sub_page;
$sub_page = (isset($_GET ['sub_page'])) ? $_GET ['sub_page'] : '';
$m2 = (isset($_admin_menu [$admin_page])) ? $_admin_menu [$admin_page] : array();
if (!empty($m2)) {
    $_call_back = (isset($m2 ['callback'])) ? $m2 ['callback'] : '';
    if (!empty($m2 ['sub']) && !empty($sub_page) && !empty($m2 ['sub'] [$sub_page])) {
        if (!empty($m2 ['sub'] [$sub_page] ['callback'])) {
            $_call_back = $m2 ['sub'] [$sub_page] ['callback'];
        }
    }

    if (class_exists($m2['plugin_class']) && trim($_call_back) != '') {
        $p_obj = new $m2['plugin_class'];
        $_call_back = array($p_obj, $_call_back);
        if (is_callable($_call_back, true)) {
            ob_start();
            call_user_func($_call_back);
            $_admin_plugin_content = ob_get_contents();
            ob_end_clean();
        }
    } else {
        // Error: Plugin load fails
    }
}

if (is_ajax()) {
    die($_admin_plugin_content);
}

require ABSPATH . '/admin/themes/default/template.php';

if (true === DEBUG) {
    Pf::database()->show_debug_console();
}

